package cn.com.duiba.quanyi.center.api.enums.insurance;

import java.util.Objects;

/**
 * @author: LuHui
 * @date: 2024/3/18 13:38
 * @description:
 */
public enum InsuranceVerifyTypeEnum {
    AUDIT(1, "审核"),
    VERIFY(2, "验真"),

    ADDITIONAL(3, "追加权益"),
    ;

    private Integer type;

    private String desc;

    InsuranceVerifyTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static InsuranceVerifyTypeEnum getByType(Integer type) {
        for (InsuranceVerifyTypeEnum typeEnum : InsuranceVerifyTypeEnum.values()) {
            if (Objects.equals(typeEnum.type, type)) {
                return typeEnum;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
