package cn.com.duiba.quanyi.center.api.log.operate;

import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.threadpool.policy.AbortPolicyWithReport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author yangyukang
 */
@ComponentScan("cn.com.duiba")
@ConditionalOnWebApplication
@Order(-1)
public class LogAutoConfiguration implements WebMvcConfigurer {

    @Bean(name = "operateLogExecutorService")
    public ExecutorService operateLogExecutorService(){
        BlockingQueue<Runnable> queue = new ArrayBlockingQueue<>(1000);
        return new ThreadPoolExecutor(5,40,
                60L, TimeUnit.SECONDS,
                queue,
                new NamedThreadFactory("ssolog"),
                new AbortPolicyWithReport());
    }


}
