package cn.com.duiba.quanyi.center.api.enums.warn;

import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author yinjiaqi
 * @date 2025-06-04 14:40:35
 */
@Getter
@AllArgsConstructor
public enum DingDingWarnTypeEnum {
    /**
     * 活动库存不足
     */
    ACTIVITY_STOCK_INSUFFICIENT(1, "活动库存不足"),

    /**
     * 批次库存不足
     */
    BATCH_STOCK_INSUFFICIENT(2, "批次库存不足"),

    /**
     * 批次即将到期
     */
    BATCH_NEAR_EXPIRY(3, "批次即将到期"),

    /**
     * 商户余额不足
     */
    MERCHANT_BALANCE_INSUFFICIENT(4, "商户余额不足"),

    /**
     * 批次创建失败
     */
    BATCH_CREATION_FAILED(5, "批次创建失败"),

    /**
     * 回款超期告警
     */
    INVOICE_RECEIVED_OVERDUE(6, "回款超期提醒"),

    /**
     * 卡单提醒
     */
    PROCESSING_ORDER(7, "卡单提醒"),
    ;

    private final Integer code;
    private final String desc;

    public static boolean needDelete(Integer type) {
        return Lists.newArrayList(ACTIVITY_STOCK_INSUFFICIENT.code, BATCH_STOCK_INSUFFICIENT.code, BATCH_NEAR_EXPIRY.code, MERCHANT_BALANCE_INSUFFICIENT.code, INVOICE_RECEIVED_OVERDUE.code, PROCESSING_ORDER.code).contains(type);
    }
}

