package cn.com.duiba.quanyi.center.api.param.pkg;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 商品包推广渠道表
 * @author kjj mybatis generator
 * @date 2023-09-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class GoodsPkgChannelSearchParam extends PageQuery {

    private static final long serialVersionUID = 16946588207961432L;

    /**
     * 商品包主键
     */
    private Long goodsPkgId;

    /**
     * 渠道id
     */
    private Long channelId;

    /**
     * 渠道名称
     */
    private String channelName;

    /**
     * 用户访问渠道类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.activity.VisitChannelTypeEnum
     */
    private Integer channelType;

    /**
     * 券类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.activity.VisitCouponTypeEnum
     */
    private Integer couponType;
}
