package cn.com.duiba.quanyi.center.api.remoteservice.qy.bank.zgbank;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.bank.zgbank.ZgbankRitCusriDto;
import cn.com.duiba.quanyi.center.api.param.bank.zgbank.ZgbankRitCusriSearchParam;
import java.util.List;

/**
 * 中国银行客户权益账户表
 * @author kjj mybatis generator
 * @date 2025-06-18
 */
@AdvancedFeignClient
public interface RemoteZgbankRitCusriService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 中国银行客户权益账户集合
     */
    List<ZgbankRitCusriDto> selectPage(ZgbankRitCusriSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ZgbankRitCusriSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 中国银行客户权益账户
     */
    ZgbankRitCusriDto selectById(Long id);

    /**
     * 新增
     * @param dto 中国银行客户权益账户
     * @return 执行结果
     */
    int insert(ZgbankRitCusriDto dto);

    /**
     * 更新
     * @param dto 中国银行客户权益账户
     * @return 影响行数
     */
    int update(ZgbankRitCusriDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据rightEntNo查询
     * @param rightEntNo rightEntNo
     * @return 中国银行客户权益账户
     */
    ZgbankRitCusriDto selectByRightEntNo(String rightEntNo);
}
