package cn.com.duiba.quanyi.center.api.remoteservice.template;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.template.TemplateFieldDto;

/**
 * 模板字段表
 * @author kjj mybatis generator
 * @date 2025-03-25
 */
@AdvancedFeignClient
public interface RemoteTemplateFieldService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 模板字段
     */
    TemplateFieldDto selectById(Long id);

    /**
     * 保存或更新模板字段
     *
     * @param dto   保存参数
     * @return 字段ID
     */
    Long saveOrUpdateTemplateField(TemplateFieldDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据主键查询
     *
     * @param idList 主键
     * @return 模板字段
     */
    List<TemplateFieldDto> selectByIdList(List<Long> idList);

    /**
     * 根据模版定义查询
     *
     * @param templateDefinitionId template definition id
     * @return {@link List }<{@link TemplateFieldDto }>
     */
    List<TemplateFieldDto> selectByTemplateDefinitionId(Long templateDefinitionId);

    /**
     * 根据模版定义id查询（包含删除）
     *
     * @param templateDefinitionId template definition id
     * @return {@link List }<{@link TemplateFieldDto }>
     */
    List<TemplateFieldDto> selectByTemplateDefinitionIdContainDelete(Long templateDefinitionId);

}
