package cn.com.duiba.quanyi.center.api.dto.common;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 上传任务表
*
* @author lizhi
* @since 2023/03/28
*/
@Data
public class UploadTaskDto implements Serializable {

    private static final long serialVersionUID = -3688952695425548925L;
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 业务id
     */
    private Long bizId;

    /**
     * 业务类型 1-上传活动白名单 2-删除活动白名单
     * {@link cn.com.duiba.galaxy.basic.enums.UploadBizTypeEnum}
     */
    private Integer bizType;

    /**
     * 操作人Id
     */
    private String operatorId;

    /**
     * 操作人姓名
     */
    private String operatorName;

    /**
     * 上传总数
     */
    private Integer totalCount;

    /**
     * 上传失败数量
     */
    private Integer failureCount;

    /**
     * 上传成功数量
     */
    private Integer successCount;

    /**
     * 文件名称
     */
    private String fileName;

    /**
     * 备注
     */
    private String uploadRemark;

    /**
     * 源文件地址
     */
    private String uploadFileUrl;

    /**
     * 失败文件地址
     */
    private String failureFileUrl;

    /**
     * 任务状态 0-初始化 1-上传中 2-上传失败(系统报错) 3-上传完成
     * {@link cn.com.duiba.galaxy.basic.enums.UploadTaskStatusEnum}
     */
    private Integer taskStatus;

    /**
     * 失败原因
     */
    private String failMsg;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}
