package cn.com.duiba.quanyi.center.api.dto.mall.goods;

import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonPrizeStockLimitConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonTakeLimitConfDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2024/5/28 14:38
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class MallSkuDetailDto extends MallSkuDto {
    private static final long serialVersionUID = 6775199995300859212L;

    /**
     * 可售库存
     */
    private Long surplusNum;

    /**
     * 已使用库存
     */
    private Long usedNum;

    /**
     * 面额，类型为微信立减金时，必填
     */
    private Long amount;

    /**
     * 需求商品id
     */
    private Long demandGoodsId;

    /**
     * 汽车服务唯一编码
     */
    private List<String> equityUnionCodeList;

    /**
     * 兑换限制(用户领取次数限制)
     */
    private ActivityCommonTakeLimitConfDto takeLimit;

    /**
     * 库存发放限制
     */
    private ActivityCommonPrizeStockLimitConfDto stockLimit;

    /**
     * 限制批次发放时间：0-不限定，1-限定
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum#getCode()
     */
    private Integer couponTimeLimitType;
}
