package cn.com.duiba.quanyi.center.api.param.coupon;

import cn.com.duiba.quanyi.center.api.enums.alipay.AlipayActivityBizStatusEnum;
import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 支付宝立减金表
 *
 * @author kjj mybatis generator
 * @date 2023-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class AlipayActivityPageParam extends PageQuery {

    private static final long serialVersionUID = 16953659385046697L;

    /**
     * 支付宝活动ID
     */
    private String alipayActId;
    /**
     * 创建人操作Id,ssoid
     */
    private Long createOperatorId;

    /**
     * 需求商品主键, tb_demand_goods.id
     */
    private List<Long> demandGoodsIds;

    /**
     * 面额，单位分
     */
    private Long couponAmount;

    /**
     * 批次类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AlipayActivityTypeEnum
     */
    private List<Integer> alipayActTypes;

    /**
     * 活动名称
     */
    private String alipayActName;


    /**
     * 活动状态
     */
    private String alipayActStatus;

    /**
     * 需求id
     */

    private Long demandId;
    /**
     * skuId
     */
    private Long skuId;
    /**
     * 是否启用，0-不启用，1启用
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer enableStatus ;

    /**
     * 业务状态：1-待分配, 2-已分配
     * {@link AlipayActivityBizStatusEnum}
     */
    private Integer bizStatus;
    /**
     * 券模板ID
     */
    private String couponTemplateId;
    /**
     * 所属银行名称
     */
    private String belongBankName;

    /**
     * 面额类型：1-固定，2-不固定
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AmountTypeEnum#getType()
     */
    private Integer amountType;

    /**
     * 不固定面额：最小面额，单位分
     */
    private Long rangeMinAmount;

    /**
     * 不固定面额：最大面额，单位分
     */
    private Long rangeMaxAmount;

    /**
     * 项目id
     */
    private Long projectId;

    /**
     * 筛选已绑定优惠券 1-是
     */
    private Integer selectBindCoupon;
}