package cn.com.duiba.quanyi.center.api.utils;

import org.apache.commons.codec.digest.DigestUtils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;

/**
 * @author xuzhigang
 * @date 2024/11/20 14:22
 **/
public class SHA256Utils {

    public static String toSha256AndBase64(String str) {
        MessageDigest digest = DigestUtils.getSha256Digest();
        return Base64.getEncoder().encodeToString(digest.digest(str.getBytes(StandardCharsets.UTF_8)));
    }

    public static void main(String[] args) {
        String input = "16223092016020801001";
        String sha256Hash = SHA256Utils.toSha256AndBase64(input);
        System.out.println("SHA-256 hash of: " + input + " is: " + sha256Hash);
    }
}

//
//import com.google.common.collect.Lists;
//
//import java.security.MessageDigest;
//import java.security.NoSuchAlgorithmException;
//import java.util.List;
//
//public class SHA256Utils {
//    public static void main(String[] args) {
//        List<String> list = Lists.newArrayList("16223092016020801001","C0DA26570D834FCEC0190C1593B1583399","C030AF7A7C8E619063E19C8274611D03C3","C030AF7A7C8E61906309D1075279E7D993","C030AF7A7C8E6190635882001E87CEEE04","C030AF7A7C8E619063D0100C11CC8F36FA","C030AF7A7C8E619063205D28DE9AF039B7","C0A3D0F22507689CC00FD1723F2C9D502D","C030AF7A7C8E619063CA4AC3227A04C554","C030AF7A7C8E61906304DB996257E2ADED","C030AF7A7C8E6190634072B384F49494DF","C030AF7A7C8E619063D1CE3D367D316607","C030AF7A7C8E61906319C89DEBB6157AE5","C030AF7A7C8E619063AAF17E3734716132","C0DA26570D834FCEC0F7F99069BB34FDEF","C0DA26570D834FCEC01C3E943BBD6C31C5","C0DA26570D834FCEC0B74BF76CF9B704EE","C0DA26570D834FCEC0B9DBF4848F139AE0","C0DA26570D834FCEC0A50C7B6E7F3D09CB","C0DA26570D834FCEC08C4EF878C308BE28","C030AF7A7C8E619063645E14E98CB8D4AD","C030AF7A7C8E6190636C67AE1B8EB2AA88","C0DA26570D834FCEC074D4FFF43AA8F545","C030AF7A7C8E61906310B5B0F8083123DE","C030AF7A7C8E619063243A0D3A22844588","C030AF7A7C8E61906334C51C0FE27E28F7","C0DA26570D834FCEC0E25A9DB9128ADCA6","C030AF7A7C8E6190636FB9BC1EABDEDE16","C030AF7A7C8E619063D2AEF346F9AD8094","C030AF7A7C8E61906371D0203F5EBD0724","C0DA26570D834FCEC081959CE26A9B1E2B","C030AF7A7C8E619063FD32C4455C4550B7","C0DA26570D834FCEC0E9B6E919C3F0CE58","C030AF7A7C8E619063E9059DA6393EFD0D","C030AF7A7C8E61906385AB8D1CA0DEB348","C030AF7A7C8E61906307C6E200E630D469","C030AF7A7C8E619063DCF4ADA1DFC63E55","C030AF7A7C8E619063DDC6D506A985E32E","C030AF7A7C8E619063F980E2B866F801B0","C030AF7A7C8E619063D45308FE5B3C3E40","C030AF7A7C8E619063813911115C6DBD49","C030AF7A7C8E619063C3503DEC5A48A50B","C030AF7A7C8E61906390408041701D50FF","C030AF7A7C8E619063549C17593CD44DC8","C030AF7A7C8E619063ABE5FCED16B8F03B","C030AF7A7C8E61906362AEE66B241CDED3","C030AF7A7C8E619063B14D6D7A1F07BB8E","C030AF7A7C8E6190635F943DDEBE8DB1C6","C030AF7A7C8E6190634F6E4F74CD26F202","C030AF7A7C8E61906358BE36771BE3F91A","C0DA26570D834FCEC037CF557302FE8E0C","C030AF7A7C8E619063055FE4357F0F4D97","C030AF7A7C8E619063A49E0798FD935320","C0DA26570D834FCEC07AD80FCCD54A92F0","C030AF7A7C8E619063D0949735AE4338FC","C030AF7A7C8E619063F70AFA66F9AACE25","C030AF7A7C8E6190634D65913670720606","C0DA26570D834FCEC0A790DD729B143A23","C030AF7A7C8E619063A79279E96659AEAB","C030AF7A7C8E6190634FFA0F1B1F13B2B2","C0DA26570D834FCEC05A42C8EB5834D0F4","C030AF7A7C8E6190633C7A9521C0BBBD30","C030AF7A7C8E619063003B70278C052EA5","C030AF7A7C8E619063F25D9085F140D8EE","C030AF7A7C8E6190634CB7869E8DC34DD2","C030AF7A7C8E619063228528CE8C2A8A56","C030AF7A7C8E619063A1E046647832B070","C030AF7A7C8E6190631B1621AE8A5C5E43","C030AF7A7C8E619063F58F21069019A663","C030AF7A7C8E61906313419D1EC2BAD52B","C030AF7A7C8E61906309152A3731F99BCA","C030AF7A7C8E619063B7740E4B7B00B44A","C030AF7A7C8E61906375E3C5214AAF14A0","C030AF7A7C8E619063C6BC916E4BF71C94","C030AF7A7C8E6190632DF4B4C62FFB1071","C0DA26570D834FCEC0657AFC88D6C7BFF7","C0DA26570D834FCEC0DDAE8FA57A3A9F39","C0DA26570D834FCEC02B878E15B035542C","C030AF7A7C8E619063CE519C56340331E6","C030AF7A7C8E6190632DE327DDA6230E30","C030AF7A7C8E619063E945BDBE0E6DF9B1","C030AF7A7C8E619063909A65344963446A","C0DA26570D834FCEC086BA752F82E5EB37","C030AF7A7C8E619063B3D1760462AFF85B","C0DA26570D834FCEC04A426EE4FC54631D","C030AF7A7C8E6190636E4112C48FC6C743","C0DA26570D834FCEC0C4C7B1A2D271912B","C0DA26570D834FCEC0865A107C3AA65EEA","C0DA26570D834FCEC0C3C1737919D8EAD2","C0A3D0F22507689CC06881D673D18D722A","C030AF7A7C8E61906328F4382281F673F6","C0DA26570D834FCEC01234113701BEC64B","C0DA26570D834FCEC09A83A8522B56C2CA","C030AF7A7C8E619063A586F27354BE476B","C030AF7A7C8E6190636D55AB1974B13989","C030AF7A7C8E6190637609998FCDA3211E","C0DA26570D834FCEC03CC8C282CCCF2F9C","C030AF7A7C8E619063584AF76BD69C31CD","C030AF7A7C8E6190630F4EA883548C4744","C030AF7A7C8E619063988279306D261444","C0DA26570D834FCEC0A16A291DD23954CB","C0DA26570D834FCEC0E6EA074A5D78E819","C030AF7A7C8E61906389CDABEBA8BDF5BF","C030AF7A7C8E619063DD619543ED45EC18","C0DA26570D834FCEC0D25DA4FD57240475","C0DA26570D834FCEC097BC06E2B1B99F6B","C0DA26570D834FCEC032D0EEAD1A6F459A","C030AF7A7C8E619063E41A05DB0AF4A99D","C030AF7A7C8E6190634CED9B39D8424763","C030AF7A7C8E619063F8F09A2F1B2208F4","C0DA26570D834FCEC0B9B4BBBF624F1A26","C030AF7A7C8E6190637398B571D74F5B4E","C030AF7A7C8E61906348DD3493BF37E1AE","C030AF7A7C8E619063ED85ABD227617CE9","C0DA26570D834FCEC02874D3E18B2CBD78","C0DA26570D834FCEC0AA5C767647117886","C0DA26570D834FCEC045857C0BD58CE471","C030AF7A7C8E619063742303397646AA2D","C030AF7A7C8E619063E95EDF9BBF6A016E","C030AF7A7C8E6190633A5B3B5D4BC2E8EB","C030AF7A7C8E6190631AD89AEE1D164E70","C0DA26570D834FCEC0F11F2212286E60A7","C030AF7A7C8E619063B3429B5D8FB5C88D","C0DA26570D834FCEC0EFFC82DA016ECAEE","C030AF7A7C8E619063181B20BCB5427CB1","C030AF7A7C8E6190633FE46BDF18338EAD","C0DA26570D834FCEC01C3881A86910CF9A","C030AF7A7C8E619063CC49F73C17CBC6EE","C030AF7A7C8E619063F1AED60FB41C7AA1","C030AF7A7C8E619063798BE771C34B0E90","C030AF7A7C8E619063F5FFF1EC05938DFB","C030AF7A7C8E6190632FD9E73E81A90A92","C030AF7A7C8E619063B08EAE1FE346D7EF","C030AF7A7C8E6190635B773587CCD7CF80","C0DA26570D834FCEC08A7BCE0429516BFC","C0DA26570D834FCEC0AAA5F753FF18E3E3","C030AF7A7C8E6190634FDCF45653766C25","C030AF7A7C8E619063D9DC58765746AD44","C030AF7A7C8E6190634F5FCDE4AD43C58B","C030AF7A7C8E6190638C9D3656FBA67A63","C0DA26570D834FCEC0C91C41F2B265B07C","C030AF7A7C8E619063BF079E102278598C","C030AF7A7C8E619063CDAA7016E858784F","C0DA26570D834FCEC04216FE9EDEFADFC1","C030AF7A7C8E6190631910812EFE4642B7","C0DA26570D834FCEC068908C410BB5BC14","C0DA26570D834FCEC010B76AF0B4703322","C0DA26570D834FCEC00C9BF0B61382D778","C0DA26570D834FCEC0559312D42DFFFC0F","C0DA26570D834FCEC047228A01F4180EB1","C030AF7A7C8E61906369837865AC73581D","C030AF7A7C8E619063AD08300A4CB35AAB","C030AF7A7C8E6190632232D7C6EEB56EA8","C030AF7A7C8E6190634E41A8E99A6AD0C4","C030AF7A7C8E619063CE02D773727F22BA","C0DA26570D834FCEC0AF3F5BF15A42A149","C0DA26570D834FCEC0B946CAB917589904","C0DA26570D834FCEC0F78BC0CE2037A4A1","C0DA26570D834FCEC01690A8E0C1C70BA9","C030AF7A7C8E6190632EEE4AE3852D79BA","C030AF7A7C8E6190637BD32F179DE0D31F","C030AF7A7C8E619063F8D74E6F80F52561","C030AF7A7C8E619063D1AE085A8D72B347","C030AF7A7C8E6190631EEFE56DCC2B9321","C030AF7A7C8E61906387097DE911174578","C030AF7A7C8E619063C4C1F509A5F0B8A4","C030AF7A7C8E619063848DF31825825B90","C0DA26570D834FCEC047AD89C87BEB2A38","C030AF7A7C8E619063DBAA91EEA4E70FDB","C030AF7A7C8E619063719411FD5ECE8265","C0DA26570D834FCEC050D7CAFC547B4F79","C030AF7A7C8E6190631A5AAEFBE232AA7D","C0DA26570D834FCEC07B71FED174BABC55","C030AF7A7C8E6190633D5FF572ECF53CD7","C0DA26570D834FCEC03E20E6EDFF0CFE0E","C030AF7A7C8E61906334410AED310109B3","C030AF7A7C8E619063F8846E3DA9760006","C0DA26570D834FCEC01EDFF2958B83F065","C030AF7A7C8E61906380565D74F18FBC17","C030AF7A7C8E619063F2670FD41C03F1AD","C030AF7A7C8E619063F55C93729C064B14","C030AF7A7C8E619063E9DCB3CE2899D17C","C030AF7A7C8E619063895A375C295B2020","C030AF7A7C8E61906314B8011350CAD811","C030AF7A7C8E6190637E73A757F004AD94","C030AF7A7C8E619063B2602CDDDDE46903","C0DA26570D834FCEC0E4C15543729E8310","C030AF7A7C8E619063E11ACF2D23AA8849","C030AF7A7C8E619063A75A108EA511EF95","C030AF7A7C8E6190630CCEE200B91884CB","C0DA26570D834FCEC0ED3ECDCD348791E4","C030AF7A7C8E619063AB8DF5291006D9C4","C030AF7A7C8E619063A31C7FEAEB782E59","C0DA26570D834FCEC0158DDA68C84990FF","C0DA26570D834FCEC0969DA1DF787B5FFB","C030AF7A7C8E6190639194766F225F4B7C","C030AF7A7C8E619063F02171E72DF9A713","C030AF7A7C8E619063D95E5B3F0E495E1E","C030AF7A7C8E6190631DEA9A4022DB4844","C0DA26570D834FCEC0904E1C605BFD58A7","C030AF7A7C8E619063A9395EE6034C87E3","C0DA26570D834FCEC05560404BCB81864A","C030AF7A7C8E619063867036ACB524F7F6","C030AF7A7C8E619063E46FD1021223AF0F","C030AF7A7C8E6190632909B57CD39EED89","C0DA26570D834FCEC0C43CADF6B6F17081","C030AF7A7C8E619063854DC3B1143AE75E","C030AF7A7C8E61906381D16E19CE125D57","C030AF7A7C8E619063A027B5B6D2C46A67","C0DA26570D834FCEC017AAD8B877EF34C3","C030AF7A7C8E619063C3795B541D092658","C0DA26570D834FCEC03DFC7A43BC8BB7D5","C030AF7A7C8E619063827A6CE07E10E9B8","C030AF7A7C8E619063DBCDA7D70095D4E3","C0DA26570D834FCEC0C269D499AE968884","C0DA26570D834FCEC04C5A0EF7AF338C18","C030AF7A7C8E619063335EC8FF380774F0","C0DA26570D834FCEC013E3920E49C78C18","C0DA26570D834FCEC00FDCF91D2BB48621","C0DA26570D834FCEC0C68F4F562AD8370F","C0DA26570D834FCEC00674ADA5828AADDC","C030AF7A7C8E61906352F020746A51E072","C030AF7A7C8E619063D7ED98F4DA454F8A","C030AF7A7C8E6190632796458F41F08E2C","C0DA26570D834FCEC0F1FA98846B6F58C7","C030AF7A7C8E619063D0D83F7C076CD93B","C030AF7A7C8E619063A55E031C33D72C88","C030AF7A7C8E619063D363B05F12541FA5","C030AF7A7C8E6190638B01E8208B561A97","C030AF7A7C8E619063287CB089F2370A61","C030AF7A7C8E619063B2AF3EAEBCAF7D04","C030AF7A7C8E6190638B90E3781623D69D","C0DA26570D834FCEC0879FAAEABB3AB4C8","C030AF7A7C8E61906306614C420FF4FF78","C030AF7A7C8E61906309759F8B412FFA30","C0DA26570D834FCEC0E0D142AC60C098FF","C030AF7A7C8E61906392E4E722C549B60A","C030AF7A7C8E619063B185C7C7608B2F5B","C030AF7A7C8E61906300F9D7BBD72D9483","C0DA26570D834FCEC076A60A1399830F96","C030AF7A7C8E6190635A0D35A20169FB2D","C030AF7A7C8E619063538EE784D38A623A","C030AF7A7C8E6190638041D695FE6749B9","C030AF7A7C8E61906348845BCAC383DF8B","C030AF7A7C8E619063ABA5F6C1747DF9B9","C030AF7A7C8E619063518F37D34B99C8E0","C030AF7A7C8E6190639A770098074F2882","C0DA26570D834FCEC0A27AC3C126C97D3B","C030AF7A7C8E6190632E59203633C1F7CC","C030AF7A7C8E6190630A1BA02986E74F47","C030AF7A7C8E61906339BD352B9B9A688A","C0DA26570D834FCEC032961438CBD11CC7","C0DA26570D834FCEC0240A5238F71E0CE5","C030AF7A7C8E6190638A39FC2465DBF214","C0DA26570D834FCEC0F9761AC9EE981FF0","C030AF7A7C8E619063B0949AB7E166142B","C0DA26570D834FCEC091B21572AC22EF33","C030AF7A7C8E619063A447D16557CC7B54","C0DA26570D834FCEC05436F7A7DE4A893E","C030AF7A7C8E619063B4BABD46F8F00C93","C030AF7A7C8E619063C581DBF3983906C6","C030AF7A7C8E619063B65650638B82132F","C030AF7A7C8E619063D5D94A4E50B564D6","C0DA26570D834FCEC025CD5AA990AFBCCE","C030AF7A7C8E6190639C293CC4A566DF86","C030AF7A7C8E6190639D137AF724ECF90D","C030AF7A7C8E61906384CDB843102D6761","C030AF7A7C8E6190634229BDC4C72CDD5E","C030AF7A7C8E6190632536E5C05AB2A555","C030AF7A7C8E619063299D65EB9AD98C69","C030AF7A7C8E61906385D29D9C0F490515","C030AF7A7C8E6190633B8E40232EA9D057","C0DA26570D834FCEC0AB0E45A9FA9A73EA","C030AF7A7C8E619063112BFB77B07B8781","C030AF7A7C8E6190630915AE78EC1EB004","C0DA26570D834FCEC0E9161A763DC9418E","C030AF7A7C8E6190633291EAC90436B425","C0DA26570D834FCEC0F21D9D146B028ABC","C030AF7A7C8E619063D1C165D9442E085D","C030AF7A7C8E619063C34D436801CFC525","C030AF7A7C8E61906350ADB7B87C78CA43","C030AF7A7C8E619063A46C5C0227FC60DB","C0DA26570D834FCEC0410D6E9731DCC39D","C030AF7A7C8E619063C883A140982E502A","C030AF7A7C8E6190636C8ADE802C43AF9B","C030AF7A7C8E619063C8EAE2DA1CF5280E","C030AF7A7C8E6190639FD61A3A93B6C116","C030AF7A7C8E6190631EF46F3A006B1929","C0DA26570D834FCEC04C511A3146758019",
//                "C030AF7A7C8E619063147CD2B9C3FFBAA9","C0DA26570D834FCEC022D2CAFC4DE73C10","C030AF7A7C8E61906301906C55B15C077E","C030AF7A7C8E619063728A1F1A5CD8554A","C030AF7A7C8E61906307706BCDC60144EE","C030AF7A7C8E619063F62FABFE54AB54D5","C030AF7A7C8E619063F280748CFDFD66F5","C030AF7A7C8E6190636CAB0FB49440AF74","C030AF7A7C8E619063244D9D1AB19995C1");
//
////        String originalString = "16223092016020801001";
//        try {
//            // 获取SHA-256 MessageDigest 实例
//            MessageDigest digest = MessageDigest.getInstance("SHA-256");
//
//            for(String originalString : list){
//                // 对字符串进行编码
//                byte[] encodedhash = digest.digest(originalString.getBytes(java.nio.charset.StandardCharsets.UTF_8));
//
//                // 将字节转换为十六进制字符串
//                StringBuilder hexString = new StringBuilder();
//                for (byte b : encodedhash) {
//                    String hex = Integer.toHexString(0xff & b);
//                    if (hex.length() == 1) hexString.append('0');
//                    hexString.append(hex);
//                }
//                // 输出哈希值
//                System.out.println(originalString + " : " + hexString.toString());
//            }
//        } catch (NoSuchAlgorithmException e) {
//            e.printStackTrace();
//        }
//    }
//}
