package cn.com.duiba.quanyi.center.api.dto.invoice;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 开票申请添加的结算单或预付款
 * @author mybatis generator 
 * @date 2025-03-10
 */
@Data
public class InvoiceApplyRefDto implements Serializable {
     
    private static final long serialVersionUID = 17415754446973541L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 发票申请ID
     */
    private Long invoiceApplyId;

    /**
     * 结算单ID/预付款ID
     */
    private Long settlementId;

    /**
     * 关联类型：1-结算单，2-预付款
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementClassificationEnum
     */
    private Integer settlementClassification;
}