package cn.com.duiba.quanyi.center.api.dto.demand;

import lombok.Data;

import java.io.Serializable;

/**
 * 需求表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@Data
public class DemandDayanDto implements Serializable {

    private static final long serialVersionUID = 6308753929200449818L;

    /**
     * 聚宝盆id
     */
    private Long id;

    /**
     * 合同id
     */
    private Long contractId;

    /**
     * 需求名称
     */
    private String demandName;

    /**
     * 对接人ID
     */
    private Long contactsId;

    /**
     * 大雁项目id
     */
    private Long dayanProjectId;

    /**
     * 项目id
     */
    private Long projectId;

    /**
     * 大雁需求类型
     */
    private String dayanDemandType;

    /**
     * 大雁需求类型名称
     */
    private String dayanDemandTypeName;

    /**
     * 负责人
     */
    private Long ownerId;

    /**
     * PM负责人
     */
    private Long projectManagerId;

    /**
     * 商务负责人
     */
    private Long commerceManagerId;

    /**
     * 应收金额（单位：分）
     */
    private Long receivableAmount;

    /**
     * 总成本（单位：分）
     */
    private Long totalCost;

    /**
     * 标准总工时/h
     */
    private String totalWorkHours;

    /**
     * 当前阶段
     */
    private Integer stage;

    /**
     * 大雁需求链接
     */
    private String link;
}