package cn.com.duiba.quanyi.center.api.param.api;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * API供货订单表
 * @author mybatis generator 
 * @date 2023-12-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ApiOrderMngSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17031456468756156L;

    /**
     * 客户单号
     */
    private String thirdOrderId;

    /**
     * api对接id
     */
    private Long apiJointId;

    /**
     * 兑吧单号
     */
    private String mainOrderNum;

    /**
     * 商品ID
     */
    private Long specId;

    /**
     * 商品类型
     * 
     * @see cn.com.duiba.quanyi.center.api.enums.api.ApiSpecTypeEnum
     */
    private Integer specType;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;
}