package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * @author nongfu
 * @Date 2024/7/16 16:28
 */
@Getter
@AllArgsConstructor
public enum ActivityTempStanardEnum {
    COMMON_STANDARD(0, "通用达标默认不实现"),
    API_STANDARD(1, "接口达标"),
    WHITE_STANDARD(2, "导入达标");


    public static ActivityTempStanardEnum getEnumByType(Integer type) {
        for (ActivityTempStanardEnum typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum;
            }
        }
        return COMMON_STANDARD;
    }

    private final Integer type;

    private final String desc;
}
