package cn.com.duiba.quanyi.center.api.param.payment;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;
import java.util.List;

/**
 * 打款申请-供应商预付款查询参数
 * @author xuzhigang
 * @date 2025-09-17 16:20
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class PaymentInfoSupplierPrepaymentSearchParam extends PageQuery {

    private static final long serialVersionUID = 17345671234567898L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 主键列表
     */
    private List<Long> ids;

    /**
     * 供应商ID
     */
    private Long supplierId;

    /**
     * 供应商ID列表
     */
    private List<Long> supplierIds;

    /**
     * 预付款名称
     */
    private String prepaymentName;

    /**
     * 状态
     */
    private Integer prepaymentStatus;

    /**
     * 状态列表
     */
    private List<Integer> prepaymentStatusList;

    /**
     * 创建人ID
     */
    private Long creatorId;

    /**
     * 创建人姓名
     */
    private String creatorName;

    /**
     * 付款ID
     */
    private Long paymentId;

    /**
     * 付款ID列表
     */
    private List<Long> paymentIds;

    /**
     * 创建时间开始
     */
    private Date gmtCreateStart;

    /**
     * 创建时间结束
     */
    private Date gmtCreateEnd;
}
