package cn.com.duiba.quanyi.center.api.remoteservice.qy.activitystockwarn;

import java.util.List;
import java.util.Map;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.activitystockwarn.ActivityStockWarnConfigDto;
import cn.com.duiba.quanyi.center.api.param.qy.activitystockwarn.ActivityStockWarnConfigUniqueKeyParam;

/**
 * 活动告警配置表
 *
 * @author kjj mybatis generator
 * @date 2024-02-04
 */
@AdvancedFeignClient
public interface RemoteActivityStockWarnConfigService {

    /**
     * 根据活动ID查询
     *
     * @param activityId   活动ID
     * @param activityType 活动类型 1-白名单活动 2 - 兑吧卡密包 7 - API供货
     * @return ActivityStockWarnConfigDto
     */
    ActivityStockWarnConfigDto selectByActivityIdAndActivityType(Long activityId, Integer activityType);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return ActivityStockWarnConfigDto
     */
    ActivityStockWarnConfigDto selectById(Long id);

    /**
     * 新增
     *
     * @param dto 活动告警配置
     * @return 执行结果
     */
    int insert(ActivityStockWarnConfigDto dto);

    /**
     * 更新
     *
     * @param dto 活动告警配置
     * @return 影响行数
     */
    int update(ActivityStockWarnConfigDto dto);

    /**
     * 测试告警
     *
     * @param dto dto
     * @return 结果
     */
    boolean test(ActivityStockWarnConfigDto dto);

    /**
     * 根据奖品ID查询库存告警配置列表
     *
     * @param prizeId 奖品ID
     * @return ActivityStockWarnConfigDto
     */
    ActivityStockWarnConfigDto selectByPrizeId(Long prizeId);

    /**
     * 根据奖品ID列表批量查询库存告警配置
     *
     * @param prizeIds 奖品ID列表
     * @return Map<Long, ActivityStockWarnConfigDto>
     */
    Map<Long, ActivityStockWarnConfigDto> selectByPrizeIds(List<Long> prizeIds);

    /**
     * 根据UK索引查询库存告警配置
     * (活动ID、活动类型、告警类型、奖品ID)
     *
     * @param param UK索引查询参数
     * @return ActivityStockWarnConfigDto
     */
    ActivityStockWarnConfigDto selectByUniqueKey(ActivityStockWarnConfigUniqueKeyParam param);

}