package cn.com.duiba.quanyi.center.api.dto.mall.goods;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import cn.com.duiba.quanyi.goods.service.api.dto.goods.AttrValDto;
import cn.com.duiba.quanyi.goods.service.api.dto.goods.AttrValueDto;
import lombok.Data;

/**
 * 商城商品sku
 * @author mybatis generator 
 * @date 2024-05-25
 */
@Data
public class MallSkuDto implements Serializable {
     
    private static final long serialVersionUID = 17166079492692659L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 删除时间
     */
    private Date logicDeleteTime;

    /**
     * 是否启用
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer enableStatus;

    /**
     * 商城商品ID
     */
    private Long mallSpuId;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 商品库spuId
     */
    private Long spuId;

    /**
     * 商品库skuId
     */
    private Long skuId;

    /**
     * 商品类型
     */
    private Integer spuType;

    /**
     * sku图片
     */
    private String mallSkuImg;

    /**
     * 划线价，单位分
     */
    private Long marketPrice;

    /**
     * 售卖价，单位分
     */
    private Long sellPrice;

    /**
     * 兑换价，单位分
     */
    private Long takePrice;

    /**
     * 规格配置 json
     */
    private List<AttrValueDto> attrConf;
}