package cn.com.duiba.quanyi.center.api.enums;

import lombok.Getter;

/**
 * 明细执行状态枚举
 *
 * @author yangyukang
 * @date 2025-01-21 15:30
 */
@Getter
public enum RefundDetailStatusEnum {

    /**
     * 待执行
     */
    PENDING(0, "待执行"),

    /**
     * 执行中
     */
    RUNNING(1, "执行中"),

    /**
     * 成功
     */
    SUCCESS(2, "成功"),

    /**
     * 失败
     */
    FAILED(3, "失败");

    private final Integer status;
    private final String desc;

    RefundDetailStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    /**
     * 根据状态码获取枚举
     *
     * @param status 状态码
     * @return 枚举值
     */
    public static RefundDetailStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        for (RefundDetailStatusEnum statusEnum : values()) {
            if (statusEnum.getStatus().equals(status)) {
                return statusEnum;
            }
        }
        return null;
    }
}
