package cn.com.duiba.quanyi.center.api.enums.insurance;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2024/3/4 14:09
 */
@Getter
@AllArgsConstructor
public enum InsuranceFundChangeTypeEnum {
    EXPEND(1, "支出"),
    INCOME(2, "收入"),
    EXPEND_CALLBACK(3, "支出回退"),
    INCOME_CALLBACK(4, "收入回退"),
    ;
    
    private final Integer type;
    
    private final String desc;
    
    public static boolean isAddAmount(Integer type) {
        return INCOME.type.equals(type) || EXPEND_CALLBACK.type.equals(type);
    }
}
