package cn.com.duiba.quanyi.center.api.enums.coupon.autocreate;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

/**
 * @author xuzhigang
 * @date 2024/5/13 15:52
 **/
@Getter
@AllArgsConstructor
public enum CashierFullCutPeriodTypeEnum {
    /**
     * 1-有效期内，任意时间可用
     */
    UNLIMITED(1, "有效期内，任意时间可用"),

    /**
     * 2-有效期内，规则日期可用
     */
    RULE(2, "有效期内，规则日期可用"),

    /**
     * 3-有效期内，不规则日期可用
     */
    IRREGULAR(3, "有效期内，不规则日期可用"),
    ;

    private final int type;

    private final String desc;

    public static CashierFullCutPeriodTypeEnum getByType(int type) {
        return Arrays.stream(values()).filter(t -> t.getType() == type).findFirst().orElse(null);
    }
}
