package cn.com.duiba.quanyi.center.api.param.coupon;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author nongfu
 * @Date 2025/4/24 10:21
 */
@Data
public class UnionPayCouponSaveOrUpdateParam implements Serializable {
    private static final long serialVersionUID = 4306115228222469108L;

    private Long id;

    /**
     * 银联活动名称
     */
    private String unionPayActivityName;
    /**
     * 优惠卷ID
     */
    private String discountId;
    /**
     * 商户ID
     */
    private String mchId;
    /**
     * 优惠立减值, 分为单位如果discount_type=reduce，那么就是具体的优惠立减额，比如：999代表满足一定金额减9.99元；如果discount_type=random，那么就是"最小额-最大额"，比如:99-990，代表立减范围从0.99元到9.99元随机决策
     */
    private Long discountValue;

    /**
     * 优惠立减门槛金额 以分为单位
     */
    private Long discountThresholdAmt;

    /**
     * 发放开始时间
     */
    private Date startTime;

    /**
     * 发放结束时间
     */
    private Date endTime;

    /**
     * 总预算
     */
    private Long totalBudget;

    /**
     * 总库存
     */
    private Long totalNum;

    /**
     * 活动规则
     */
    private String activityRule;
    /**
     * 创建人操作Id,ssoid
     */
    private Long createOperatorId;

    /**
     * 创建人操作Id,ssoname
     */
    private String createOperatorName;

}
