package cn.com.duiba.quanyi.center.api.remoteservice.template;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.template.TemplateDefinitionDto;
import cn.com.duiba.quanyi.center.api.param.template.TemplateDefinitionSearchParam;

import java.util.List;

/**
 * 模板定义表
 * @author kjj mybatis generator 
 * @date 2025-03-25
 */
@AdvancedFeignClient
public interface RemoteTemplateDefinitionService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 模板定义集合
     */
    List<TemplateDefinitionDto> selectPage(TemplateDefinitionSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(TemplateDefinitionSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 模板定义
     */
    TemplateDefinitionDto selectById(Long id);

    /**
     * 保存或更新模板定义
     *
     * @param dto   保存参数
     * @return 模板定义ID
     */
    Long saveOrUpdateTemplateDefinition(TemplateDefinitionDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 按模板code选择
     *
     * @param templateCode 模板code
     * @return {@link TemplateDefinitionDto }
     */
    TemplateDefinitionDto selectByTemplateCode(String templateCode);

}