package cn.com.duiba.quanyi.center.api.remoteservice.invoice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.BaseResultDto;
import cn.com.duiba.quanyi.center.api.dto.contract.ContractDto;
import cn.com.duiba.quanyi.center.api.dto.invoice.InvoiceApplyDetailDto;
import cn.com.duiba.quanyi.center.api.dto.invoice.InvoiceApplyDto;
import cn.com.duiba.quanyi.center.api.dto.invoice.InvoiceApplyTaskMqDto;
import cn.com.duiba.quanyi.center.api.dto.invoice.InvoiceDto;
import cn.com.duiba.quanyi.center.api.param.invoice.InvoiceApplyRevokeDeductionParam;
import cn.com.duiba.quanyi.center.api.param.invoice.InvoiceApplySaveParam;
import cn.com.duiba.quanyi.center.api.param.invoice.InvoiceApplySearchParam;
import cn.com.duiba.quanyi.center.api.param.invoice.InvoiceRedOffsetParam;

import java.util.List;
import java.util.Set;

/**
 * 开票申请
 * @author kjj mybatis generator
 * @date 2024-12-03
 */
@AdvancedFeignClient
public interface RemoteInvoiceApplyService {

    /**
     * 保存开票申请
     *
     * @param param 开票申请参数
     * @return 开票申请id
     */
    BaseResultDto<Long> saveInvoiceApplyNew(InvoiceApplySaveParam param);

    /**
     * 撤销抵扣
     * @param param 撤销抵扣参数
     * @return 是否成功
     */
    BaseResultDto<Boolean> revokeDeduction(InvoiceApplyRevokeDeductionParam param);

    /**
     * 批量提交发票
     *
     * @param invoiceApplyId 开票申请id
     * @param list 发票信息
     * @return 提交结果
     */
    BaseResultDto<Boolean> batchUploadInvoice(Long invoiceApplyId, List<InvoiceDto> list);

    /**
     * 重新发起开票申请
     *
     * @param invoiceApplyId 开票申请id
     * @return 重试结果
     */
    BaseResultDto<Boolean> retry(Long invoiceApplyId);

    /**
     * 移除发票
     *
     * @param invoiceApplyId 开票申请id
     * @param invoiceId 发票id
     * @return 删除结果
     */
    boolean removeInvoice(Long invoiceApplyId, Long invoiceId);

    /**
     * 发起红冲
     *
     * @param invoiceApplyId 开票申请id
     * @param invoiceId 发票id
     * @param operatorId 发起人id
     * @return 结果
     */
    boolean redOffset(Long invoiceApplyId, Long invoiceId, Long operatorId);

    /**
     * 发起红冲-new
     * @param param 参数
     * @return 结果
     */
    boolean redOffsetNew(InvoiceRedOffsetParam param);

    /**
     * 撤销
     * @param invoiceApplyId 开票申请ID
     * @return 结果
     */
    BaseResultDto<Boolean> close(Long invoiceApplyId);

    /**
     * 获取开票申请详情
     *
     * @param id 开票申请id
     * @return 开票申请详情
     */
    InvoiceApplyDetailDto detail(Long id);

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 开票申请集合
     */
    List<InvoiceApplyDto> selectPage(InvoiceApplySearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InvoiceApplySearchParam param);

    /**
     * 根据主键批量查询
     * @param ids 主键
     * @return 开票申请
     */
    List<InvoiceApplyDto> selectByIds(Set<Long> ids);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 开票申请
     */
    InvoiceApplyDto selectById(Long id);

    /**
     * 新增
     * @param dto 开票申请
     * @return 执行结果
     */
    int insert(InvoiceApplyDto dto);

    /**
     * 更新
     * @param dto 开票申请
     * @return 影响行数
     */
    int update(InvoiceApplyDto dto);

    /**
     * 逻辑删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 同步主订单状态
     * @param invoiceApplyId 开票申请ID
     * @return 结果
     */
    BaseResultDto<Boolean> syncInvoiceApplyLockStatus(Long invoiceApplyId);


    /**
     * 同步主订单状态
     * @param dto 任务
     * @return 结果
     */
    BaseResultDto<Boolean> syncInvoiceApplyLockStatusNew(InvoiceApplyTaskMqDto dto);

    /**
     * 更改开票申请状态
     * @param id 主键
     * @param invoiceApplyStatus 开票申请状态
     * @param originStatus 原状态
     * @return 执行结果
     */
    int updateInvoiceApplyStatus(Long id, Integer invoiceApplyStatus, Integer originStatus);

    /**
     * 查询项目有效的合同
     * @param projectId 项目id
     * @return 合同列表
     */
    List<ContractDto> getProjectValidContractList(Long projectId);
}
