package cn.com.duiba.quanyi.center.api.enums.bigdata;

import java.util.HashMap;
import java.util.Map;

/**
 * @author chenyongkun
 */

public enum BigdataHologresTableEnum {

    WX_STOCK_BILL_RUN_DETAIL(" stock_id as \"批次ID\",concat('`',coupon_id) as \"优惠id\",coupon_type as \"优惠类型\",case when transaction_type='退款' then round((discount_amount/100::numeric), 2) * -1 else round((discount_amount/100::numeric), 2) end as \"优惠金额\",round((total_amount/100::numeric), 2) as \"订单总金额\",transaction_type as \"交易类型\",concat('`',pay_order_num) as \"支付单号\",consume_time as \"消耗时间\",consume_mch_id as \"消耗商户号\",device_id as \"设备号\",concat('`',bank_serial_num) as \"银行流水号\",concat('`',third_order_id) as \"客户订单号\",concat('`',goods_order_no) as \"兑吧订单号\" ", "quan_yi.tb_quanyi_settlement_order_wx_detail", "微信进行中账单表"),

    WX_STOCK_BILL_STOPED_DETAIL(" stock_id as \"批次ID\",concat('`',coupon_id) as \"优惠id\",coupon_type as \"优惠类型\",case when transaction_type='退款' then round((discount_amount/100::numeric), 2) * -1 else round((discount_amount/100::numeric), 2) end as \"优惠金额\",round((total_amount/100::numeric), 2) as \"订单总金额\",transaction_type as \"交易类型\",concat('`',pay_order_num) as \"支付单号\",consume_time as \"消耗时间\",consume_mch_id as \"消耗商户号\",device_id as \"设备号\",concat('`',bank_serial_num) as \"银行流水号\",concat('`',third_order_id) as \"客户订单号\",concat('`',goods_order_no) as \"兑吧订单号\" ", "quan_yi.tb_quanyi_settlement_order_wx_detail", "微信已结束账单表"),

    ALIPAY_STOCK_HX_BILL_DETAIL(" act_id as \"批次号\",act_name as \"活动名称\",act_type as \"活动类型\",coupon_type as \"消耗类型\",consume_time as \"核销时间\",case when coupon_type='退款' then round((discount_amount/100::numeric), 2) * -1 else round((discount_amount/100::numeric), 2) end as \"红包核销面额（元）\",round((total_amount/100::numeric), 2) as \"订单金额（元）\",round((pay_amount/100::numeric), 2) as \"实付金额（元）\",concat('`',bank_serial_num) as \"银行流水号\",concat('`',pay_order_num) as \"支付宝交易号\",consume_mch_pid as \"商户PID\",pre_recharge_type as \"预充值方式\",consume_mch_name as \"商家名称\",consume_mch_id as \"门店ID\",consume_mch_store_name as \"门店名称\",voucher_id as \"券ID\",coupon_template_id as \"模板ID\",card_num_top_6 as \"卡号前六位\",cbd_name as \"商圈名称\",cbd_store_name as \"商圈门店名称\",concat('`',goods_order_no) as \"兑吧订单号\",third_order_id as \"第三方订单号\" ", "quan_yi.tb_quanyi_settlement_order_alipay_detail", "支付宝核销holo表"),

    QUANYI_ORDER_BILL_DETAIL(" demand_goods_id as \"商品ID\",prize_name as \"商品名称\",round((wx_coupon_amount/100::numeric), 2) as \"面额\",account_no as \"账号\",open_id as \"微信openid\",wx_coupon_id as \"优惠券ID\",to_char(receive_success_time, 'YYYY-MM-DD HH24:MI:SS') as \"核销时间\",concat('`',goods_order_no) as \"兑吧订单号\",third_order_id as \"第三方订单号\" ", "quan_yi.tb_quanyi_order_bill_detail", "权益非立减金holo表"),

    //结算单
    SETTLEMENT_ORDER_OBJECT_BILL_DETAIL(" demand_name as \"需求名称\",demand_goods_id as \"需求商品ID\",goods_name as \"商品名称\",sku_conf as \"规格\",activity_id as \"活动ID\",activity_name as \"活动名称\",goods_biz_type as \"活动类型\",prize_name as \"奖品名称\",goods_order_no as \"兑吧订单号\",order_time as \"订单创建时间\",delivery_time as \"发货时间\",sign_time as \"签收时间\",express_company_name as \"快递名称\",express_no as \"快递编号\",name as \"收件人姓名\",phone as \"收件人手机号\",address as \"收件地址\",boc_cif_number as \"核心客户号\",boc_customer_id as \"网银客户号\",boc_branch_id as \"网银开户机构号\" ", "quan_yi.tb_quanyi_settlement_order_object_detail", "结算订单明细-实物"),
    SETTLEMENT_ORDER_WX_BILL_DETAIL(" stock_id as \"批次ID\",coupon_id as \"优惠ID\",coupon_type as \"优惠类型\",case when transaction_type='退款' then round((discount_amount/100::numeric), 2) * -1 else round((discount_amount/100::numeric), 2) end as \"优惠金额（元）\",round((total_amount/100::numeric), 2) as \"订单总金额（元）\",transaction_type as \"交易类型\",pay_order_num as \"支付单号\",consume_time as \"消耗时间\",consume_mch_id as \"消耗商户号\",device_id as \"设备号\",bank_serial_num as \"银行流水号\",goods_order_no as \"兑吧订单号\",order_time as \"订单创建时间\",receive_success_time as \"领取成功时间\",activity_id as \"活动ID\",activity_name as \"活动名称\",goods_biz_type as \"活动类型\",api_joint_id as \"对接ID\",third_order_id as \"客户订单号\",open_id as \"open_id\",spec_id as \"供给商品ID\",boc_cif_number as \"核心客户号\",boc_customer_id as \"网银客户号\",boc_branch_id as \"网银开户机构号\" ", "quan_yi.tb_quanyi_settlement_order_wx_detail", "结算订单明细-微信"),
    SETTLEMENT_ORDER_DP_BILL_DETAIL(" demand_name as \"需求名称\",demand_goods_id as \"需求商品ID\",goods_name as \"商品名称\",sku_conf as \"规格\",activity_id as \"活动ID\",activity_name as \"活动名称\",goods_biz_type as \"活动类型\",prize_name as \"奖品名称\",goods_order_no as \"兑吧订单号\",order_time as \"订单创建时间\",delivery_time as \"发货时间\",sign_time as \"签收时间\",express_company_name as \"快递名称\",express_no as \"快递编号\",name as \"收件人姓名\",phone as \"收件人手机号\",address as \"收件地址\",boc_cif_number as \"核心客户号\",boc_customer_id as \"网银客户号\",boc_branch_id as \"网银开户机构号\" ", "quan_yi.tb_quanyi_settlement_order_object_detail", "结算订单明细-单品"),
    SETTLEMENT_ORDER_KM_BILL_DETAIL(" demand_name as \"需求名称\",demand_goods_id as \"需求商品ID\",goods_name as \"商品名称\",sku_conf as \"规格\",purchase_spu_type as \"采购商品类型\",activity_id as \"活动ID\",activity_name as \"活动名称\",goods_biz_type as \"活动类型\",prize_name as \"奖品名称\",goods_order_no as \"兑吧订单号\",order_time as \"订单创建时间\",receive_success_time as \"领取成功时间\",stock_id as \"批次号\",coupon_id as \"优惠券ID\",round((coupon_amount/100::numeric), 2) as \"面额\",user_id as \"用户ID\",phone_number as \"手机号码\",account_no as \"充值账号\",coupon_code as \"券码\",link as \"链接\",api_joint_id as \"对接ID\",third_order_id as \"客户订单号\",open_id as \"open_id\",spec_id as \"供给商品ID\",boc_cif_number as \"核心客户号\",boc_customer_id as \"网银客户号\",boc_branch_id as \"网银开户机构号\" ", "quan_yi.tb_quanyi_settlement_order_other_detail", "结算订单明细-卡密"),
    SETTLEMENT_ORDER_ALIPAY_BILL_DETAIL(" act_id as \"活动ID\",act_name as \"活动名称\",act_type as \"活动类型\",coupon_type as \"消耗类型\",consume_time as \"核销时间\",case when coupon_type='退款' then round((discount_amount/100::numeric), 2) * -1 else round((discount_amount/100::numeric), 2) end as \"红包核销面额\",round((total_amount/100::numeric), 2) as \"订单金额\",round((pay_amount/100::numeric), 2) as \"实付金额\",bank_serial_num as \"银行流水号\",pay_order_num as \"支付宝交易号\",consume_mch_pid as \"商家PID\",pre_recharge_type as \"预充值方式\",consume_mch_name as \"商家名称\",consume_mch_id as \"门店ID\",consume_mch_store_name as \"门店名称\",voucher_id as \"券ID\",coupon_template_id as \"券模板ID\",card_num_top_6 as \"卡号前6位\",cbd_name as \"商圈名称\",cbd_store_name as \"商圈门店名称\",goods_order_no as \"兑吧订单号\",order_time as \"订单创建时间\",receive_success_time as \"领取成功时间\",activity_id as \"活动ID\",activity_name as \"活动名称\",goods_biz_type as \"活动类型\",api_joint_id as \"对接ID\",third_order_id as \"客户订单号\",open_id as \"open_id\",spec_id as \"供给商品ID\",boc_cif_number as \"核心客户号\",boc_customer_id as \"网银客户号\",boc_branch_id as \"网银开户机构号\" ", "quan_yi.tb_quanyi_settlement_order_alipay_detail", "结算订单明细-支付宝"),
    SETTLEMENT_ORDER_ALIPAY_COIN_BILL_DETAIL(" consume_time as \"核销时间\",transaction_type as \"交易类型\",voucher_id as \"券ID\",voucher_name as \"券名称\",case when transaction_type='退款' then round((discount_amount/100::numeric), 2) * -1 else round((discount_amount/100::numeric), 2) end as \"券核销面额(元)\",round((total_amount/100::numeric), 2) as \"订单金额\",round((pay_amount/100::numeric), 2) as \"券核销实收金额（元）\",refund_batch_no as \"退款批次号\",store_order_num as \"商户订单号\",pay_order_num as \"支付宝交易号\",consume_mch_pid as \"核销商户账号\",consume_mch_name as \"核销商户名称\",consume_mch_store_no as \"核销门店编号\",consume_mch_store_name as \"核销门店名称\",hx_serial_num as \"核销流水号\",user_account as \"使用方账号\",coupon_template_id as \"模板ID\",goods_order_no as \"兑吧订单号\",order_time as \"订单创建时间\",receive_success_time as \"领取成功时间\",activity_id as \"活动ID\",activity_name as \"活动名称\",goods_biz_type as \"活动类型\",api_joint_id as \"对接ID\",third_order_id as \"客户订单号\",open_id as \"open_id\",spec_id as \"供给商品ID\" ", "quan_yi.tb_quanyi_settlement_order_alipay_coin_detail", "结算订单明细-支付宝数币"),

    CCB_SETTLEMENT_ORDER_WX_BILL_DETAIL(" '微信','@',stock_id,'@',spec_id,'@',coupon_id,'@',third_order_id,'@',to_char(TO_TIMESTAMP(receive_success_time, 'YYYY-MM-DD HH24:MI:SS'),'@',transaction_type,'@',to_char(TO_TIMESTAMP(consume_time, 'YYYY-MM-DD HH24:MI:SS'), 'YYYYMMDDHH24MISS'),'@',pay_order_num,'@',bank_serial_num,'@',round((total_amount/100::numeric), 2) as \"订单总金额（元）\",'@',case when transaction_type='退款' then round((discount_amount/100::numeric), 2) * -1 else round((discount_amount/100::numeric), 2) end as \"优惠金额（元）\",'@',consume_mch_id as \"消耗商户号\",'@|' ", "quan_yi.tb_quanyi_settlement_order_wx_v2_detail", "建行结算订单明细-微信"),
    CCB_SETTLEMENT_ORDER_ALIPAY_BILL_DETAIL(" '支付宝','@',act_id,'@',spec_id,'@',voucher_id,'@',third_order_id,'@',to_char(TO_TIMESTAMP(receive_success_time, 'YYYY-MM-DD HH24:MI:SS'),'@',coupon_type,'@',to_char(TO_TIMESTAMP(consume_time, 'YYYY-MM-DD HH24:MI:SS'), 'YYYYMMDDHH24MISS'),'@',pay_order_num,'@',bank_serial_num,'@',round((total_amount/100::numeric), 2) as \"订单金额\",'@',case when coupon_type='退款' then round((discount_amount/100::numeric), 2) * -1 else round((discount_amount/100::numeric), 2) end as \"红包核销面额\",'@',consume_mch_name,'@|' ", "quan_yi.tb_quanyi_settlement_order_alipay_detail", "建行结算订单明细-支付宝"),
    ;
    /**
     * 查询部分
     */
    private final String sqlSegment;

    /**
     * 表名
     */
    private final String tableName;

    /**
     * 解释说明
     */
    private final String desc;

    /**
     * 枚举集合
     */
    private static final Map<String, BigdataHologresTableEnum> enumMap = new HashMap<>();

    BigdataHologresTableEnum(String sqlSegment, String tableName, String desc) {
        this.sqlSegment = sqlSegment;
        this.tableName = tableName;
        this.desc = desc;
    }

    public String getSqlSegment() {
        return sqlSegment;
    }

    public String getTableName() {
        return tableName;
    }

    public String getDesc() {
        return desc;
    }

    public static Map<String, BigdataHologresTableEnum> getEnumMap() {
        return enumMap;
    }

    static {
        BigdataHologresTableEnum[] values = BigdataHologresTableEnum.values();
        for (BigdataHologresTableEnum value : values) {
            enumMap.put(value.toString(), value);
        }
    }

}
