package cn.com.duiba.quanyi.center.api.dto.activity;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 活动管理员表
 * @author mybatis generator 
 * @date 2024-04-22
 */
@Data
public class ActivityAdminDto implements Serializable {
     
    private static final long serialVersionUID = 17137559983309849L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 管理员手机号
     */
    private String adminPhone;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 添加人Id
     */
    private Long operatorId;

    /**
     * 添加人姓名
     */
    private String operatorName;

    /**
     * 添加时间
     */
    private Date addTime;

    /**
     * 删除人Id，用于排查问题
     */
    private Long deleteOperatorId;

    /**
     * 删除人姓名，用于排查问题
     */
    private String deleteOperatorName;

    /**
     * 删除时间
     */
    private Date deleteTime;

    /**
     * 绑定用户时间
     */
    private Date bindTime;
}