package cn.com.duiba.quanyi.center.api.dto.demand;

import cn.com.duiba.quanyi.center.api.enums.DemandTypeEnum;
import cn.com.duiba.quanyi.goods.service.api.enums.subject.SubjectEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 需求表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@Data
public class DemandDto implements Serializable {

    private static final long serialVersionUID = 6308753929200449818L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 合同主键, tb_contract.id
     */
    private Long contractId;

    /**
     * 需求名称
     */
    private String demandName;

    /**
     * 需求描述
     */
    private String demandDesc;

    /**
     * 对接人ID
     */
    private Long contactsId;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 创建人id
     */
    private Long createOperatorId;

    /**
     * 创建人名称
     */
    private String createOperatorName;

    /**
     * 客户id
     */
    private Long partnerId;

    /**
     * 合作开始时间
     */
    private Date demandStartTime;

    /**
     * 合作结束时间
     */
    private Date demandEndTime;


    /**
     * 需求类型, 0-常规需求, 1-线下需求
     *
     * @see DemandTypeEnum
     */
    private Integer demandType;

    /**
     * 项目id
     */
    private Long projectId;

    /**
     * 兑吧业务主体
     *
     * @see SubjectEnum#getType()
     */
    private Long duibaSubject;

    /**
     * 审核状态
     * @see cn.com.duiba.quanyi.center.api.enums.workflow.ApprovalStatusEnum
     */
    private Integer approvalStatus;

    /**
     * 采购状态
     * @see cn.com.duiba.quanyi.center.api.enums.demand.PurchaseStatusEnum
     */
    private Integer purchaseStatus;

    /**
     * 需求审批状态（目前仅通过es查询会有该字段） 来源tb_demand_change_record.approval_status
     */
    private Integer demandApprovalStatus;

    /**
     * 归属业务组
     * @see cn.com.duiba.quanyi.center.api.enums.contract.BusinessGroupTypeEnum
     */
    private Integer businessGroup;

    /**
     * 发起审批时间
     */
    private Date approvalStartTime;

    /**
     * 回退合同金额
     */
    private Long refundContractAmount;
}
