package cn.com.duiba.quanyi.center.api.param.invoice;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 历史开票
 * @author mybatis generator
 * @date 2025-01-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class InvoiceHistorySearchParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 17364024891153223L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 归属项目ID
     */
    private Long projectId;

    /**
     * 项目ID
     */
    private List<Long> projectIds;

    /**
     * 发票号
     */
    private String invoiceNum;

    /**
     * 发票抬头
     */
    private String invoiceTitle;

    /**
     * 发票抬头
     */
    private Set<String> invoiceTitles;

    /**
     * 发票时间
     */
    private Date invoiceIssueTime;

    /**
     * 已开票金额（单位分）
     */
    private Long invoicedAmount;

    /**
     * 已回款金额（单位分）
     */
    private Long receivedAmount;

    /**
     * 需求id
     */
    private Long demandId;

    /**
     * 对接人id
     */
    private Long contactsId;

    /**
     * 客户id
     */
    private Long partnerId;

    /**
     * 开始时间
     */
    private Date beginDate;

    /**
     * 结束时间
     */
    private Date endDate;

    /**
     * 发票抬头(精准匹配)
     */
    private String termInvoiceTitle;

    /**
     * 是否过滤0可关联金额
     */
    private boolean filterZeroAmount;

    /**
     * 开票开始时间
     */
    private Date invoiceIssueStartTime;

    /**
     * 开票结束时间
     */
    private Date invoiceIssueEndTime;

    /**
     * 所属业务大类
     * @see cn.com.duiba.quanyi.center.api.enums.contract.BusinessGroupTypeEnum#getType()
     */
    private Integer businessGroup;

    /**
     * 回款超期状态 0-回款未超期 1-回款已超期
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.InvoiceReceivedOverdueStatusEnum
     */
    private Integer receivedOverdueStatus;
}
