package cn.com.duiba.quanyi.center.api.remoteservice.wx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.wx.WxWriteOffElectronicCertificateDto;
import cn.com.duiba.quanyi.center.api.param.wx.WxWriteOffElectronicCertificateSearchParam;

import java.util.List;

/**
 * 微信核销数据电子凭证表
 * @author kjj mybatis generator 
 * @date 2024-06-19
 */
@AdvancedFeignClient
public interface RemoteWxWriteOffElectronicCertificateService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 微信核销数据电子凭证集合
     */
    List<WxWriteOffElectronicCertificateDto> selectPage(WxWriteOffElectronicCertificateSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(WxWriteOffElectronicCertificateSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 微信核销数据电子凭证
     */
    WxWriteOffElectronicCertificateDto selectById(Long id);

    /**
     * 新增
     * @param dto 微信核销数据电子凭证
     * @return 执行结果
     */
    int insert(WxWriteOffElectronicCertificateDto dto);

    /**
     * 更新
     * @param dto 微信核销数据电子凭证
     * @return 影响行数
     */
    int update(WxWriteOffElectronicCertificateDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}