package cn.com.duiba.quanyi.center.api.enums.coupon.autocreate;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

/**
 * 全场券有效期类型枚举
 *
 * @author xuzhigang
 * @date 2024/4/23 16:44
 **/
@Getter
@AllArgsConstructor
public enum FullCouponPeriodTypeEnum {
    /**
     * 1-有效期内，任意时间可用
     */
    UNLIMITED(1, "有效期内，任意时间可用"),
    /**
     * 2-有效期内，用户领券后X天内可用
     */
    LIMITED(2, "有效期内，用户领券后X天内可用"),

    /**
     * 3-有效期内，规则日期可用
     */
    RULE(3, "有效期内，规则日期可用"),

    /**
     * 4-有效期内，不规则日期可用
     */
    IRREGULAR(4, "有效期内，不规则日期可用"),
    ;

    private final int type;

    private final String desc;

    public static FullCouponPeriodTypeEnum getByType(int type) {
        return Arrays.stream(values()).filter(t -> t.getType() == type).findFirst().orElse(null);
    }
}
