package cn.com.duiba.quanyi.center.api.remoteservice.qystatistic;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qystatistic.SupplierStatDto;
import cn.com.duiba.quanyi.center.api.param.qystatistic.SupplierStatSearchParam;

import java.util.List;

/**
 * 供应商统计表
 *
 * @author xuzhigang
 * @date 2025-09-18 15:50
 */
@AdvancedFeignClient
public interface RemoteSupplierStatService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 供应商统计
     */
    SupplierStatDto selectById(Long id);

    /**
     * 根据统计纬度ID和类型查询
     *
     * @param statId   统计纬度ID
     * @param statType 统计纬度类型
     * @return 供应商统计
     */
    SupplierStatDto selectByStatIdAndType(String statId, Integer statType);

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     *
     * @param param 查询条件
     * @return 供应商统计集合
     */
    List<SupplierStatDto> selectPage(SupplierStatSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(SupplierStatSearchParam param);

    /**
     * 新增
     *
     * @param dto 供应商统计
     * @return 执行结果
     */
    int insert(SupplierStatDto dto);

    /**
     * 更新
     *
     * @param dto 供应商统计
     * @return 执行结果
     */
    int update(SupplierStatDto dto);
}
