package cn.com.duiba.quanyi.center.api.dto.questionnaire;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;

/**
 * 问卷-题目表
 * @author mybatis generator
 * @date 2025-10-28
 */
@Data
public class QuestionnaireQuestionsDto implements Serializable {

    private static final long serialVersionUID = 17616462508357449L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 问卷ID
     */
    private Long questionnaireId;

    /**
     * 题目类型（1-单选，2-多选，3-文本）
     * @see cn.com.duiba.quanyi.center.api.enums.questionnaire.QuestionnaireQuestionTypeEnum
     */
    private Integer questionType;

    /**
     * 题目内容
     */
    private String questionText;

    /**
     * 是否必答
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer isRequired;

    /**
     * 题目排序
     */
    private Integer sortOrder;

    /**
     * 选择题选项
     */
    private List<String> questionOptions;
}
