package cn.com.duiba.quanyi.center.api.param.project;

import cn.com.duiba.quanyi.center.api.enums.project.BelongingBusinessTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 项目
 * @author mybatis generator
 * @date 2024-10-21
 */
@Data
public class ProjectIdsSearchParam implements Serializable {

    private static final long serialVersionUID = 17294988941151269L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 关联客户ID
     */
    private Long partnerId;

    /**
     * 商务负责人ID
     */
    private Long commerceManagerId;

    /**
     * 商务负责人ID
     */
    private List<Long> commerceManagerIdList;

    /**
     * 运营负责人ID
     */
    private Long operationsManagerId;

    /**
     * 创建人ID
     */
    private Long createOperatorId;

    /**
     * 所属业务
     * @see BelongingBusinessTypeEnum#getType()
     */
    private Integer belongingBusiness;

    /**
     * 最多多少条，必填
     */
    private int size;
}
