package cn.com.duiba.quanyi.center.api.param.invoice;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 外部发票表查询参数
 * @author xuzhigang
 * @date 2025-01-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class InvoiceExternalSearchParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 7284659301847592L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 主键集合
     */
    private List<Long> ids;

    /**
     * 上传发票人ssoId
     */
    private Long createOperatorId;

    /**
     * 上传发票人ssoId集合
     */
    private List<Long> createOperatorIds;

    /**
     * 上传发票人ssoName
     */
    private String createOperatorName;

    /**
     * 发票金额最小值
     */
    private Long invoiceAmountMin;

    /**
     * 发票金额最大值
     */
    private Long invoiceAmountMax;

    /**
     * 发票附件
     */
    private String invoiceAttachmentUrl;

    /**
     * 转服务费凭证
     */
    private String invoiceCredentialUrl;

    /**
     * 创建时间开始
     */
    private Date gmtCreateStart;

    /**
     * 创建时间结束
     */
    private Date gmtCreateEnd;

    /**
     * 开票时间开始
     */
    private Date invoiceIssueTimeStart;

    /**
     * 开票时间结束
     */
    private Date invoiceIssueTimeEnd;

    /**
     * 关联业务id
     */
    private Long bizId;

    /**
     * 关联业务id集合
     */
    private List<Long> bizIds;

    /**
     * 关联业务类型
     */
    private Integer bizType;

    /**
     * 关联业务类型集合
     */
    private List<Integer> bizTypes;
}
