package cn.com.duiba.quanyi.center.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@Getter
@AllArgsConstructor
public enum DemandTypeEnum {
    CONVENTION_DEMAND(0, "常规需求"),
    OFFLINE_DEMAND(1, "线下需求"),
    MOBILE_PAYMENT(2, "快捷支付"),
    ADVANCE_PAYMENT(3, "垫资"),
    VIRTUAL(4, "虚拟"),
    OBJECT(5, "实物"),
    DIGITAL_DAYAN_PROJECT(6, "数字营销-大雁项目"),
    ;
    private final Integer code;

    private final String desc;

    /**
     * 根据code获取描述
     * @param code
     * @return
     */
    public static String getDesc(Integer code) {
        for (DemandTypeEnum demandTypeEnum : values()) {
            if (demandTypeEnum.getCode().equals(code)) {
                return demandTypeEnum.getDesc();
            }
        }
        return null;
    }

    private static final Set<Integer> ACTIVITY_RELATED_DEMAND_TYPE_SET = Collections.unmodifiableSet(new HashSet<>(Arrays.asList(
            CONVENTION_DEMAND.getCode()
            , MOBILE_PAYMENT.getCode()
            , VIRTUAL.getCode()
            , OBJECT.getCode()
    )));

    public static Set<Integer> getActivityRelatedDemandTypes() {
        return ACTIVITY_RELATED_DEMAND_TYPE_SET;
    }
}
