package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 优惠券过期类型枚举
 *
 * @author yangyukang
 * @date 2025-05-13
 */
@Getter
@AllArgsConstructor
public enum CouponExpireTypeEnum {

    NO(0, "无"),

    /**
     * 最晚可领时间
     */
    SPECIFY_DATE(1, "指定时间日期"),

    /**
     * 立减金的批次结束前X天有效
     */
    REVERSE_DAYS(2, "倒叙时间"),

    /**
     * 链接生成后X天内有效
     */
    ORDER_DAY(3, "顺序时间"),

    /**
     * 当月有效
     */
    NOW_MONTH_END(4, "当前月底"),

    /**
     * 当周有效
     */
    NOW_WEEK_END(5, "当周周末"),
    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

}
