package cn.com.duiba.quanyi.center.api.param.mall.goods;

import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonPrizeStockLimitConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonTakeLimitConfDto;
import lombok.Data;

import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import java.io.Serializable;
import java.util.List;

/**
 * sku更新参数
 * @author xuzhigang
 * @date 2024/05/28
 */
@Data
public class MallGoodsSkuUpdateParam implements Serializable {
    /**
     * 主键，编辑时必填
     */
    private Long id;

    /**
     * 是否启用
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum#getCode()
     */
    private Integer enableStatus;

    /**
     * SKU优先级最高的图
     */
    private String mallSkuImg;

    /**
     * 划线价，单位分
     */
    private Long marketPrice;

    /**
     * 售卖价，单位分
     */
    private Long sellPrice;

    /**
     * 售卖价，单位分
     */
    private Long takePrice;

    /**
     * 面额，类型为微信立减金时，必填
     */
    private Long amount;

    /**
     * 可售库存
     */
    private Long surplusNum;

    /**
     * 关联批次
     */
    private List<MallActPrizeCouponRelParam> couponRelList;

    /**
     * 权益服务编码
     */
    private List<String> equityUnionCodeList;

    /**
     * 兑换限制(用户领取次数限制)
     */
    private ActivityCommonTakeLimitConfDto takeLimit;

    /**
     * 库存发放限制
     */
    private ActivityCommonPrizeStockLimitConfDto stockLimit;

    /**
     * 限制批次发放时间：0-不限定，1-限定
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum#getCode()
     */
    private Integer couponTimeLimitType;

    /**
     * 需求商品id
     */
    private Long demandGoodsId;
}
