package cn.com.duiba.quanyi.center.api.dto.qystatistic;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 微信立减金账单详情
 * @author mybatis generator 
 * @date 2025-01-13
 */
@Data
public class WxCouponBillDetailDto implements Serializable {
     
    private static final long serialVersionUID = 17367402478989234L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 微信返回的券ID
     */
    private String wxCouponId;

    /**
     * 微信批次号
     */
    private String stockId;

    /**
     * 核销代金券的商户号
     */
    private String consumeMchId;

    /**
     * 微信支付系统生成的订单号
     */
    private String transactionId;

    /**
     * 交易时间
     */
    private Date tradeTime;

    /**
     * 交易类型，1-支付，2-退款
     */
    private Integer tradeType;

    /**
     * 交易金额，单位分
     */
    private Long tradeAmount;

    /**
     * 实付金额，单位分
     */
    private Long paidAmount;

    /**
     * 优惠金额，单位分
     */
    private Long discountAmount;

    /**
     * 退款金额，单位分
     */
    private Long refundAmount;

    /**
     * 商品库订单号
     */
    private String goodsOrderNo;

    /**
     * 数据来源类型
     */
    private Integer dataSourceType;
}