package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.activity.ActivityPostingLinkDto;
import cn.com.duiba.quanyi.center.api.param.qy.activity.ActivityPostingLinkSearchParam;
import java.util.List;

/**
 * 活动投放链接表
 * @author kjj mybatis generator
 * @date 2025-06-05
 */
@AdvancedFeignClient
public interface RemoteActivityPostingLinkService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 活动投放链接集合
     */
    List<ActivityPostingLinkDto> selectPage(ActivityPostingLinkSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ActivityPostingLinkSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 活动投放链接
     */
    ActivityPostingLinkDto selectById(Long id);

    /**
     * 新增
     * @param dto 活动投放链接
     * @return 执行结果
     */
    int insert(ActivityPostingLinkDto dto);

    /**
     * 更新
     * @param dto 活动投放链接
     * @return 影响行数
     */
    int update(ActivityPostingLinkDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}
