package cn.com.duiba.quanyi.center.api.enums.settlement;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2024/11/25 16:23
 */
@AllArgsConstructor
@Getter
public enum SettlementStatusEnum {
    // 1.保存结算单-初始化
    // 2.保存选择商品唯一标记-创建中
    // 3.提交给大数据计算-创建中
    // 4.轮询大数据计算结果-创建中
    // 5.分页拉取大数据商品明细、id，写入数据库中-待开票 // 3-5任意失败-创建失败 重试-删除所有id，重新跑，3-5续期分布式锁
    // 6.回填/回退开票金额时，开票金额大于0小于总开票金额-部分开票
    // 7.回填/回退开票金额时，等于总开票金额-已开票待回款
    // 8.回退开票金额时，开票金额小于0-待开票
    // 9.回填/回退回款金额时，若总回款金额小于开票金额-已开票待回款
    // 10.回填/回退回款金额时，若总回款金额等于开票金额-已回款
    INIT(0, "初始化"),
    CREATING(1, "创建中"),
    CREATE_FAIL(2, "创建失败"),
    PENDING_INVOICING(3, "待开票"),
    PARTIAL_INVOICING(4, "部分开票"),
    INVOICED_AND_PENDING_PAYMENT(5, "已开票待回款"),
    RECEIVED_PAYMENT(6, "已回款"),
    ;

    private final Integer status;

    private final String desc;

    public static String getDescByStatus(Integer status) {
        for (SettlementStatusEnum value : SettlementStatusEnum.values()) {
            if (value.status.equals(status)) {
                return value.desc;
            }
        }
        return null;
    }
}
