package cn.com.duiba.quanyi.center.api.enums.cardsecret;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 卡密回退任务明细状态枚举
 *
 * @author yangyukang
 * @date 2025-11-11 16:41
 */
@AllArgsConstructor
@Getter
public enum CardSecretRefundTaskDetailStatusEnum {

    PENDING(1, "待处理"),
    PROCESSING(2, "处理中"),
    COMPLETED(3, "已完成"),
    FAILED(4, "已失败"),
    CANCELLED(5, "已取消");

    private final Integer status;

    private final String desc;

    private static final Map<Integer, CardSecretRefundTaskDetailStatusEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(CardSecretRefundTaskDetailStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据状态值获取枚举
     *
     * @param status 状态值
     * @return 枚举
     */
    public static CardSecretRefundTaskDetailStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }
}

