package cn.com.duiba.quanyi.center.api.enums.api;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/7/3 13:32
 */
@Getter
@AllArgsConstructor
public enum ApiJointConfigExtEnum {
    NOTIFY_URL(1, "回调地址"),
    VALIDATE_URL(2, "参数验证地址"),
    SIGN_TIME_OUT(3, "验签超时时间(秒)"),
    SHORT_URL_EXPIRE_NOTIFY(4, "短链过期通知(1-开,0-关)"),
    IS_BIND_UID(5, "是否绑定uid(1-开,0-关)"),
    IS_LINK_BIND_USER(6, "短链是否绑定用户(1-开,0-关)"),
    COUPON_NEED_EXPIRED(7, "立减金是否需要过期状态(1-开,0-关)"),
    SUPPLY_WX_APPIDS(8, "微信appid(,分割)"),
    FAIL_ORDER_IS_RETRY(9, "订单重试开关(1-开,0-关)"),
    /**
     * 默认是生成订单，补库存后可以重试成功，该配置项开启时，将不再生成订单直接返回失败
     */
    NO_STOCK_RETURN_FAIL(10, "库存不足返回失败开关(1-开,0-关)"),
    ;

    private final Integer confName;

    private final String desc;

    /**
     * 检查已经定义的枚举confName是否有冲突
     */
    static {
        Set<Integer> confNameSet = Arrays.stream(ApiJointConfigExtEnum.values()).map(ApiJointConfigExtEnum::getConfName).collect(Collectors.toSet());
        if (confNameSet.size() != ApiJointConfigExtEnum.values().length) {
            throw new RuntimeException("ApiJointConfigExtEnum.confName有冲突");
        }
    }

    public static void main(String[] args) {
        System.out.println(ApiJointConfigExtEnum.NOTIFY_URL.getConfName());
    }

}
