package cn.com.duiba.quanyi.center.api.enums.cardsecret;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 卡密回退任务状态枚举
 *
 * @author yangyukang
 * @date 2025-11-11 16:41
 */
@AllArgsConstructor
@Getter
public enum CardSecretRefundTaskStatusEnum {
    
    SUBMITTING(1, "发起中"),
    SUBMIT_FAILED(2, "发起失败"),
    REFUNDING(3, "回退中"),
    REFUND_FAILED(4, "回退失败"),
    PARTIAL_REFUND(5, "部分回退"),
    REFUND_SUCCESS(6, "回退成功");

    private final Integer status;

    private final String desc;

    private static final Map<Integer, CardSecretRefundTaskStatusEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(CardSecretRefundTaskStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据状态值获取枚举
     *
     * @param status 状态值
     * @return 枚举
     */
    public static CardSecretRefundTaskStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }
}

