package cn.com.duiba.quanyi.center.api.remoteservice.deposit;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.deposit.PaymentInfoDepositDto;
import cn.com.duiba.quanyi.center.api.dto.deposit.PaymentInfoDepositSumDto;
import cn.com.duiba.quanyi.center.api.param.demand.DemandPaymentInfoSumParam;
import cn.com.duiba.quanyi.center.api.param.deposit.PaymentInfoDepositAssociateExternalInvoiceParam;
import cn.com.duiba.quanyi.center.api.param.deposit.PaymentInfoDepositSaveParam;
import cn.com.duiba.quanyi.center.api.param.deposit.PaymentInfoDepositSearchParam;

import java.util.List;

/**
 * 保证金表远程服务
 * @author xuzhigang
 * @date 2025-01-21
 */
@AdvancedFeignClient
public interface RemotePaymentInfoDepositService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保证金信息
     */
    PaymentInfoDepositDto selectById(Long id);

    /**
     * 根据保证金id查询
     * @param paymentInfoId 保证金id
     * @return 保证金信息
     */
    PaymentInfoDepositDto selectByPaymentInfoId(Long paymentInfoId);

    /**
     * 根据创建人ID查询
     * @param createOperatorId 创建人ID
     * @return 保证金信息列表
     */
    List<PaymentInfoDepositDto> selectByCreateOperatorId(Long createOperatorId);

    /**
     * 分页查询
     * @param param 查询参数
     * @return 保证金信息列表
     */
    List<PaymentInfoDepositDto> selectPage(PaymentInfoDepositSearchParam param);

    /**
     * 不分页查询
     * @param param 查询参数
     * @return 保证金信息列表
     */
    List<PaymentInfoDepositDto> selectList(PaymentInfoDepositSearchParam param);

    /**
     * 查询总数
     * @param param 查询参数
     * @return 总数
     */
    long selectCount(PaymentInfoDepositSearchParam param);

    /**
     * 保存或更新保证金信息
     * @param param 保证金信息
     * @return 保证金id
     */
    Long saveOrUpdate(PaymentInfoDepositSaveParam param);

    /**
     * 更新
     * @param dto 保证金信息
     * @return 影响行数
     */
    int update(PaymentInfoDepositDto dto);

    /**
     * 根据条件汇总保证金金额和回款金额
     * @param param 查询参数（paymentPurpose、businessGroup、createOperatorId可选）
     * @return 保证金汇总结果
     */
    PaymentInfoDepositSumDto sumDepositAmounts(DemandPaymentInfoSumParam param);

    /**
     * 更新关联合同ID
     * @param id 主键
     * @param relatedContractId 关联合同ID，可以为0表示清除关联
     * @return 执行结果
     */
    int updateRelatedContractId(Long id, Long relatedContractId);

    /**
     * 保证金关联外部发票
     * @param param 关联参数
     * @return 外部发票ID
     */
    Long associateExternalInvoice(PaymentInfoDepositAssociateExternalInvoiceParam param);

    /**
     * 删除保证金和外部发票的关联关系
     * 删除关联关系后，同时扣除已占用回款金额和已回款金额
     * @param paymentInfoId 保证金ID
     * @param invoiceExternalId 外部发票ID
     * @return 是否删除成功
     */
    Boolean removeAssociationWithExternalInvoice(Long paymentInfoId, Long invoiceExternalId);
}
