package cn.com.duiba.quanyi.center.api.param.activity;

import java.util.List;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class ActivityPageQueryParam extends PageQuery {

    private static final long serialVersionUID = 2963781322008217990L;
    /**
     * 活动状态
     */
    private Integer activityStatus;

    /**
     * 活动类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum
     */
    private Integer activityType;

    /**
     * 活动类型集合
     *
     * @see cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum
     */
    private List<Integer> activityTypes;

    /**
     * 活动ID
     */
    private Integer activityId;

    /**
     * 活动ID
     */
    private Long activityIdLong;

    /**
     * 创建人sso id
     */
    private Long createOperatorId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 需求id
     */
    private Long demandId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 需求id集合
     */
    private List<Long> demandIds;
}
