package cn.com.duiba.quanyi.center.api.dto.youjia;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 优加微信立减金账单明细表
 * 
 * @author cxw
 * @date 2025-10-30 15:00
 */
@Data
public class WxCouponBillYjDto implements Serializable {

    private static final long serialVersionUID = 3847562109826457193L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 微信返回的券ID
     */
    private String wxCouponId;

    /**
     * 微信批次号
     */
    private String stockId;

    /**
     * 核销代金券的商户号
     */
    private String consumeMchId;

    /**
     * 微信支付系统生成的订单号
     */
    private String transactionId;

    /**
     * 交易时间
     */
    private Date tradeTime;

    /**
     * 交易类型，1-支付，2-退款
     */
    private Integer tradeType;

    /**
     * 交易金额，单位分
     */
    private Long tradeAmount;

    /**
     * 实付金额，单位分
     */
    private Long paidAmount;

    /**
     * 优惠金额，单位分
     */
    private Long discountAmount;

    /**
     * 银行流水号
     */
    private String bankTransactionId;
}

