package cn.com.duiba.quanyi.center.api.dto.template;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.quanyi.center.api.enums.template.TemplateFieldBizTypeEnum;
import cn.com.duiba.quanyi.center.api.enums.template.TemplateFieldTypeEnum;
import lombok.Data;

/**
 * 模板字段表
 * @author mybatis generator 
 * @date 2025-03-25
 */
@Data
public class TemplateFieldDto implements Serializable {
     
    private static final long serialVersionUID = 17428836121789732L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 模板ID
     */
    private Long templateDefinitionId;

    /**
     * 字段编码
     */
    private String fieldCode;

    /**
     * 字段名称
     */
    private String fieldName;

    /**
     * 字段类型(string/number/boolean/object/array)
     *
     * @see TemplateFieldTypeEnum#getType()
     */
    private String fieldType;

    /**
     * 父级字段编码
     */
    private String parentCode;

    /**
     * 业务查询类型 0:无查询 1:供货id 2:活动id
     *
     * @see TemplateFieldBizTypeEnum#getType()
     */
    private Integer bizType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否删除 0:未删除 1:已删除
     */
    private Integer isDeleted;
}