package cn.com.duiba.quanyi.center.api.remoteservice.dayan;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.contract.ContractDto;
import cn.com.duiba.quanyi.center.api.param.ContractDayanPageQueryParam;
import cn.com.duiba.quanyi.center.api.param.ContractPageQueryParam;

import java.util.List;

/**
 * 大雁合同服务
 */
@AdvancedFeignClient
public interface RemoteDayanContractService {

    /**
     * 根据合同编号查询
     * @param contractCode 合同编号
     * @return 返回实体信息
     */
    ContractDto findByContractCode(String contractCode);

    /**
     * 根据合同编号集合查询
     * @param contractCodes 合同编号集合
     * @return 返回实体信息
     */
    List<ContractDto> findByContractCodes(List<String> contractCodes);

    /**
     * 根据合同id查询
     * @param id 合同id
     * @return 返回实体信息
     */
    ContractDto findById(Long id);

    /**
     * 根据合同ids查询
     * @param ids 合同id集合
     * @return 返回实体信息
     */
    List<ContractDto> findByIds(List<Long> ids);

    /**
     * 分页查询
     *
     * @param contractDayanPageQueryParam
     * @return
     */
    List<ContractDto> findPageByParam(ContractDayanPageQueryParam contractDayanPageQueryParam);

    /**
     * 分页总条数
     *
     * @param contractDayanPageQueryParam
     * @return
     */
    Integer selectCount(ContractDayanPageQueryParam contractDayanPageQueryParam);


}
