package cn.com.duiba.quanyi.center.api.remoteservice.workflow;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.BaseResultDto;
import cn.com.duiba.quanyi.center.api.dto.workflow.WorkflowOptionsDto;

import java.util.List;

/**
 * 审批流选项
 * @author kjj mybatis generator 
 * @date 2024-10-29
 */
@AdvancedFeignClient
public interface RemoteWorkflowOptionsService {

    /**
     * 根据选项类型查询
     * @param workflowOptionsType 选项类型
     * @see cn.com.duiba.quanyi.center.api.enums.workflow.WorkflowOptionsTypeEnum
     * @return 审批流选项列表
     */
    List<WorkflowOptionsDto> selectByWorkflowOptionsType(Integer workflowOptionsType);

    /**
     * 刷新选项
     * @param workflowOptionsType 选项类型
     * @see cn.com.duiba.quanyi.center.api.enums.workflow.WorkflowOptionsTypeEnum
     * @return 任务ID
     */
    String refreshOptions(Integer workflowOptionsType);

    /**
     * 刷新选项结果
     * @param taskId 任务ID
     * @return 结果
     */
    BaseResultDto<Boolean> refreshOptionsResult(String taskId);
}