package cn.com.duiba.quanyi.center.api.dto.warn;

import cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 钉钉工作通知告警记录表
 * @author mybatis generator
 * @date 2025-06-04
 */
@Data
public class DingDingWarnRecordDto implements Serializable {

    private static final long serialVersionUID = 17490180483397413L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 告警类型1：活动库存不足，2：批次库存不足，3.批次即将到期，4：商户余额不足，5：批次创建失败
     * @see cn.com.duiba.quanyi.center.api.enums.warn.DingDingWarnTypeEnum
     */
    private Integer warnType;

    /**
     * 活动id字符串，批次号...以此类推
     */
    private String statId;

    /**
     * 告警标题
     */
    private String warnTitle;

    /**
     * link,  text,  markdown
     * @see cn.com.duiba.message.service.api.enums.DingMsgTypeEnum
     */
    private String msgType;

    /**
     * 处理状态 0=待处理，1=已处理
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer processStatus;

    /**
     * 告警时间
     */
    private Date warnTime;

    /**
     * 告警通知人
     */
    private Long warnOperatorId;

    /**
     * 活动类型
     * @see BizActTypeEnum
     */
    private Integer activityType;

    /**
     * 告警内容
     */
    private String warnContent;
}
