package cn.com.duiba.quanyi.center.api.remoteservice.insurance.harbin;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.BaseResultDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.harbin.InsuranceHarbinGrantResultDto;

/**
 * @author: LuHui
 * @date: 2024/7/2 11:40
 * @description:
 */
@AdvancedFeignClient
public interface RemoteInsuranceHarbinEquityTakeService {

    /**
     * 异步发放权益
     * @param harbinEquityId
     * @param phone
     */
    void asyncGrantEquity(Long harbinEquityId, String phone);

    /**
     * 轮询发放权益结果
     * @param harbinEquityId
     * @return
     */
    BaseResultDto<InsuranceHarbinGrantResultDto> grantEquityResult(Long harbinEquityId);
}
